/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client.renderers;

import dev.cammiescorner.icarus.Icarus;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.client.models.DiscordsWingsModel;
import dev.cammiescorner.icarus.client.models.FeatheredWingsModel;
import dev.cammiescorner.icarus.client.models.FlandresWingsModel;
import dev.cammiescorner.icarus.client.models.LeatherWingsModel;
import dev.cammiescorner.icarus.client.models.LightWingsModel;
import dev.cammiescorner.icarus.client.models.WingEntityModel;
import dev.cammiescorner.icarus.client.models.ZanzasWingsModel;
import dev.cammiescorner.icarus.common.items.WingItem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class WingsFeatureRenderer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private WingEntityModel<T> wingModel;
    private final FeatheredWingsModel<T> featheredWings;
    private final LeatherWingsModel<T> leatherWings;
    private final LightWingsModel<T> lightWings;
    private final FlandresWingsModel<T> flandresWings;
    private final DiscordsWingsModel<T> discordsWings;
    private final ZanzasWingsModel<T> zanzasWings;

    public WingsFeatureRenderer(class_3883<T, M> context, class_5599 loader) {
        super(context);
        this.featheredWings = new FeatheredWingsModel(loader.method_32072(IcarusClient.FEATHERED));
        this.leatherWings = new LeatherWingsModel(loader.method_32072(IcarusClient.LEATHER));
        this.lightWings = new LightWingsModel(loader.method_32072(IcarusClient.LIGHT));
        this.flandresWings = new FlandresWingsModel(loader.method_32072(IcarusClient.FLANDRE));
        this.discordsWings = new DiscordsWingsModel(loader.method_32072(IcarusClient.DISCORD));
        this.zanzasWings = new ZanzasWingsModel(loader.method_32072(IcarusClient.ZANZA));
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (entity instanceof class_1657) {
            Optional component = TrinketsApi.getTrinketComponent(entity);
            component.ifPresent(trinketComponent -> {
                class_1792 patt2946$temp;
                if (!trinketComponent.isEquipped(stack -> stack.method_7909() instanceof WingItem) && Icarus.HAS_WINGS.test((class_1297)entity) && (patt2946$temp = Icarus.WINGS.apply((class_1297)entity).getWings()) instanceof WingItem) {
                    String wingType;
                    WingItem wingItem = (WingItem)patt2946$temp;
                    float[] primaryColour = wingItem.getPrimaryColour().method_7787();
                    float[] secondaryColour = wingItem.getSecondaryColour().method_7787();
                    float r1 = primaryColour[0];
                    float g1 = primaryColour[1];
                    float b1 = primaryColour[2];
                    float r2 = secondaryColour[0];
                    float g2 = secondaryColour[1];
                    float b2 = secondaryColour[2];
                    String string = wingType = wingItem.getWingType() != WingItem.WingType.UNIQUE ? wingItem.getWingType().toString().toLowerCase(Locale.ROOT) : class_2378.field_11142.method_10221((Object)wingItem).method_12832().replaceAll("_wings", "");
                    if (wingItem.getWingType() == WingItem.WingType.FEATHERED || wingItem.getWingType() == WingItem.WingType.MECHANICAL_FEATHERED) {
                        this.wingModel = this.featheredWings;
                    }
                    if (wingItem.getWingType() == WingItem.WingType.DRAGON || wingItem.getWingType() == WingItem.WingType.MECHANICAL_LEATHER) {
                        this.wingModel = this.leatherWings;
                    }
                    if (wingItem.getWingType() == WingItem.WingType.LIGHT) {
                        this.wingModel = this.lightWings;
                    }
                    if (wingType.equals("flandres")) {
                        this.wingModel = this.flandresWings;
                    }
                    if (wingType.equals("discords")) {
                        this.wingModel = this.discordsWings;
                    }
                    if (wingType.equals("zanzas")) {
                        this.wingModel = this.zanzasWings;
                    }
                    class_2960 layer1 = new class_2960("icarus", "textures/entity/" + wingType + "_wings.png");
                    class_2960 layer2 = new class_2960("icarus", "textures/entity/" + wingType + "_wings_2.png");
                    matrices.method_22903();
                    matrices.method_22904(0.0, 0.0, 0.125);
                    this.method_17165().method_17081(this.wingModel);
                    this.wingModel.setAngles((class_1309)entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                    this.renderWings(matrices, vertexConsumers, wingItem.method_7854(), class_1921.method_23580((class_2960)layer2), light, r2, g2, b2);
                    this.renderWings(matrices, vertexConsumers, wingItem.method_7854(), class_1921.method_23580((class_2960)layer1), light, r1, g1, b1);
                    matrices.method_22909();
                } else {
                    trinketComponent.getAllEquipped().forEach(pair -> {
                        class_1799 stack = (class_1799)pair.method_15441();
                        class_1792 patt5088$temp = stack.method_7909();
                        if (patt5088$temp instanceof WingItem) {
                            String wingType;
                            WingItem wingItem = (WingItem)patt5088$temp;
                            float[] primaryColour = wingItem.getPrimaryColour().method_7787();
                            float[] secondaryColour = wingItem.getSecondaryColour().method_7787();
                            float r1 = primaryColour[0];
                            float g1 = primaryColour[1];
                            float b1 = primaryColour[2];
                            float r2 = secondaryColour[0];
                            float g2 = secondaryColour[1];
                            float b2 = secondaryColour[2];
                            String string = wingType = wingItem.getWingType() != WingItem.WingType.UNIQUE ? wingItem.getWingType().toString().toLowerCase(Locale.ROOT) : class_2378.field_11142.method_10221((Object)wingItem).method_12832().replaceAll("_wings", "");
                            if (wingItem.getWingType() == WingItem.WingType.FEATHERED || wingItem.getWingType() == WingItem.WingType.MECHANICAL_FEATHERED) {
                                this.wingModel = this.featheredWings;
                            }
                            if (wingItem.getWingType() == WingItem.WingType.DRAGON || wingItem.getWingType() == WingItem.WingType.MECHANICAL_LEATHER) {
                                this.wingModel = this.leatherWings;
                            }
                            if (wingItem.getWingType() == WingItem.WingType.LIGHT) {
                                this.wingModel = this.lightWings;
                            }
                            if (wingType.equals("flandres")) {
                                this.wingModel = this.flandresWings;
                            }
                            if (wingType.equals("discords")) {
                                this.wingModel = this.discordsWings;
                            }
                            if (wingType.equals("zanzas")) {
                                this.wingModel = this.zanzasWings;
                            }
                            class_2960 layer1 = new class_2960("icarus", "textures/entity/" + wingType + "_wings.png");
                            class_2960 layer2 = new class_2960("icarus", "textures/entity/" + wingType + "_wings_2.png");
                            matrices.method_22903();
                            matrices.method_22904(0.0, 0.0, 0.125);
                            this.method_17165().method_17081(this.wingModel);
                            this.wingModel.setAngles((class_1309)entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                            this.renderWings(matrices, vertexConsumers, stack, class_1921.method_23580((class_2960)layer2), light, r2, g2, b2);
                            this.renderWings(matrices, vertexConsumers, stack, class_1921.method_23580((class_2960)layer1), light, r1, g1, b1);
                            matrices.method_22909();
                        }
                    });
                }
            });
        }
    }

    public void renderWings(class_4587 matrices, class_4597 vertexConsumers, @Nullable class_1799 stack, class_1921 renderLayer, int light, float r, float g, float b) {
        class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumers, (class_1921)renderLayer, (boolean)false, (stack != null && stack.method_7958() ? 1 : 0) != 0);
        this.wingModel.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, r, g, b, 1.0f);
    }
}

